'
' Instances of this class are used to represent a warehouse.
'
Public Class Warehouse
    Inherits SecurityZone

    '
    ' This method is called by the notify method so that this
    ' object can have a chance to handle measurements.
    '
    Public Overrides Function HandleNotification(ByVal measurement As Integer, ByVal sensor As Sensor) As Boolean
        Return False
    End Function 'HandleNotification

    '
    ' This method is called by a child zone to report a fire.
    ' It is expected that the child zone has turned on
    ' sprinklers or taken other appropriate measures to control
    ' the fire within the child zone. The purpose of this method
    ' is to be overridden by other subclasses so that it can
    ' take any necessary actions outside of the child zone.
    '
    Public Overrides Sub FireAlarm(ByVal zone As SecurityZone)
        If TypeOf zone Is Area Then
            ' Turn on sprinklers in surrounding areas
            '...
            ' Don't call base.FireAlarm because that will turn on the
            ' sprinkler for the whole warehouse.
            If Not (Parent Is Nothing) Then
                Parent.FireAlarm(zone)
            End If
            Return
        End If
        MyBase.FireAlarm(zone)
    End Sub 'fireAlarm
End Class 'Warehouse
